(function () {
  var shiftKeyDown = false;
  window.addEventListener("keydown", function (e) {
    if (remediationUtil.keys.isLeftShift(e)) {
      shiftKeyDown = true;
    }
  });
  window.addEventListener("keyup", function (e) {
    if (remediationUtil.keys.isLeftShift(e)) {
      shiftKeyDown = false;
    }
  });
  const remediationUtil = UserWayWidgetApp.addLib("remediation_util");
  remediationUtil.execOnPage("yieldstreet.com/faq", function () {
    remediationUtil.waitUntil(
      function () {
        const dts = document.querySelectorAll('[class*="FAQSectionItem__QAContainer-sc"] dt');
        if (dts.length) {
          return dts;
        }
      },
      function (dts) {
        const handleKeyDownEvent = function (index, dt, e) {
          const isClosed = dt.getAttribute("is-open") === "false";
          if (isClosed && remediationUtil.keys.isTab(e) && !shiftKeyDown) {
            const nextDt = document.querySelector(`[dt="${index + 1}"]`);
            if (nextDt) {
              e.preventDefault();
              nextDt.focus();
            }
          }

          if (isClosed && remediationUtil.keys.isTab(e) && shiftKeyDown) {
            const prevDt = document.querySelector(`[dt="${index - 1}"]`);
            if (prevDt) {
              e.preventDefault();
              prevDt.focus();
            }
          }

          if (remediationUtil.keys.isEnter(e)) {
            dt.click();
          }
        };

        const handleClickEvent = function (dt, e) {
          const isClosed = dt.getAttribute("is-open") === "false";
          if (isClosed) {
            dt.setAttribute("is-open", "true");
            remediationUtil.announce("List opened");
          } else {
            dt.setAttribute("is-open", "false");
            remediationUtil.announce("List closed");
          }
        };

        for (let i = 0; i < dts.length; i++) {
          const dt = dts[i];
          dt.setAttribute("is-open", "false");
          dt.setAttribute("dt", i);
          dt.setAttribute("tabindex", "0");
          dt.addEventListener("keydown", handleKeyDownEvent.bind(this, i, dt));
          dt.addEventListener("click", handleClickEvent.bind(this, dt));
        }
      }
    );
  });

  remediationUtil.execOnPage("yieldstreet.com/login", function () {
    remediationUtil.waitUntil(
      function () {
        return document.querySelector('[class*="Login__LoginBox-sc"');
      },
      function (loginBox) {
        const emailInput = loginBox.querySelector('[type="email"]');
        emailInput.setAttribute("aria-label", "Email");
        const passwordInput = loginBox.querySelector('[type="password"]');
        passwordInput.setAttribute("aria-label", "Password");
        const loginButton = loginBox.querySelector("#login-login");
        remediationUtil.clickOnEnter(loginButton);
        let announcement = "";
        loginButton.addEventListener("click", function () {
          const errors = loginBox.querySelectorAll(".MuiFormHelperText-root");
          for (let error of errors) {
            const type = error.parentNode.querySelector("input").getAttribute("type");
            announcement += type + " field: " + error.innerText;
          }
          if (errors.length) {
            remediationUtil.announce(announcement);
          }
        });
      }
    );
  });

  remediationUtil.execOnPage("yieldstreet.com/signup", function () {
    setInterval(function () {
      remediationUtil.waitUntil(
        function () {
          return document.querySelector(".MuiFormGroup-root:not(.uw-remediated)");
        },
        function (wrapper) {
          wrapper.classList.add("uw-remediated");
          const labels = wrapper.querySelectorAll(".MuiFormControlLabel-root");
          for (let label of labels) {
            label.setAttribute("tabindex", "0");
            label.setAttribute("role", "button");
            remediationUtil.clickOnEnter(label);
          }
        }
      );
    }, 1000);
    remediationUtil.waitUntil(
      function () {
        return document.querySelector('[class*="PrimarySignupCentre__FormWrapper"]');
      },
      function (signupForm) {
        const firstNameInput = signupForm.querySelector('input[data-cy="input-firstName"]');
        firstNameInput.setAttribute("aria-label", "first name");

        const lastNameInput = signupForm.querySelector('input[data-cy="input-lastName"]');
        lastNameInput.setAttribute("aria-label", "last name");

        const emailInput = signupForm.querySelector('input[data-cy="input-email"]');
        emailInput.setAttribute("aria-label", "email");

        const passwordInput = signupForm.querySelector('input[data-cy="input-password"]');
        passwordInput.setAttribute("aria-label", "password");
      }
    );
  });
})();