(function(FS) {
  var session = FS.getCurrentSession(), sessionUrl = FS.getCurrentSessionURL();
  function retryWithBackoff(condition, callback, maxWait, failureMsg, timeoutCallback) {
    var totalTimeExpired = 0;
    var wait = 64;
    var resultFn = function() {
      if (condition()) {
        callback();
        return;
      }
      wait = Math.min(wait * 2, 1024);
      if (totalTimeExpired > maxWait) {
        FS.log('warn', failureMsg);
        !!timeoutCallback && timeoutCallback(failureMsg);
        return;
      }
      totalTimeExpired += wait
      setTimeout(resultFn, wait);
    };
    return resultFn;
  }
  function loadSession(key) {
	var lastSession = window['localStorage'].getItem(key);
    if (!lastSession) {
      lastSession = FS._cookies()[key];
    }
    return lastSession
  }
  function saveSession(key, session) {
    window['localStorage'].setItem(key, session);
  }

	var intercomSessionUrl = sessionUrl + '?integration_src=intercom';
	var intercomSessionId = encodeURIComponent(session);
    function intercomOnPage() {
      return window['Intercom'] && typeof(Intercom)=="function";
    }
    function intercomBooted() {
      return document.querySelector(".intercom-app, .intercom-lightweight-app");
    }
    function fsIntercomInit() {
      var lastSession = loadSession('fs_intercom');
      if (session != lastSession) {
        saveSession('fs_intercom', session);
        var fsMetadata = {
	      "Session Link": {
	        value: "Play in FullStory",
            url: intercomSessionUrl,
            sessionId: intercomSessionId
          },
          "Session Time": (new Date()).toUTCString()
        };

        Intercom('trackEvent', 'New FullStory Session', fsMetadata);
        retryWithBackoff(intercomBooted, intercomUpdateAttrAsync, 8000, 'The FullStory integration with Intercom loaded, but did not detect that Intercom booted successfully.', intercomInitFailure)();
      }
    }
    retryWithBackoff(intercomOnPage, fsIntercomInit, 30000, 'The FullStory integration with Intercom loaded, but did not detect Intercom on the page.', intercomInitFailure)();

    function intercomUpdateAttrAsync() {
      Intercom('update', {'Latest FullStory Session': intercomSessionUrl, 'Latest FullStory Session ID': intercomSessionId});
      FS('stat', {
        eventType: 'INTEGRATION_INITIALIZED',
        payload: {
          provider_id: 'intercom',
          event_status: 'SUCCESS'
        }
      });
    }

    function intercomInitFailure(message) {
      FS('stat', {
        eventType: 'INTEGRATION_INITIALIZED',
        payload: {
          provider_id: 'intercom',
          event_status: 'FAILURE',
          metadata: { detail: message }
        }
      });
    }
	
  if (window['olark'] && typeof(olark)=="function") {
	var olarkSessionUrl = sessionUrl + '?integration_src=olark';
    var send = function() {
      var lastSession = loadSession('fs_olark');
      if (session != lastSession) {
        saveSession('fs_olark', session);
        olark('api.chat.sendNotificationToOperator', {body: 'FullStory Session: ' + olarkSessionUrl});
      }
    };
    // A conversation may begin multiple times, especially on single-page apps.
    olark('api.chat.onBeginConversation', function() {
      send();
    });
    olark('api.visitor.getDetails', function(details) {
      if (details.isConversing) {
        send();
      }
    });
    FS('stat', {
      eventType: 'INTEGRATION_INITIALIZED',
      payload: {
        provider_id: 'olark',
        event_status: 'SUCCESS',
        metadata: { sessionUrl: olarkSessionUrl }
      }
    })
  } else {
    FS.log("warn", "Olark script was not loaded even though the Olark integration is turned on.");
    FS('stat', {
      eventType: 'INTEGRATION_INITIALIZED',
      payload: {
        provider_id: 'olark',
        event_status: 'FAILURE',
        metadata: { detail: 'Olark script was not loaded even though the Olark integration is turned on.' }
      }
    })
  }
  
})(window['_fs_namespace'] ? window[window['_fs_namespace']] : window['FS'])